% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrAtRisk.R
\name{survLable}
\alias{survLable}
\title{Adds number at risk of a survival model to a plot.
Adds label to plot.}
\usage{
survLable(
  text,
  x,
  y,
  font = 1,
  cex = 1,
  col.text = "black",
  len.flag,
  lty.flag = 1,
  lwd.flag = 1,
  bgcol.flag,
  lncol.flag = "black"
)
}
\arguments{
\item{text}{String, content of the label.}

\item{x}{A numeric value for the position at the x-axis.}

\item{y}{A numeric value for the position at the y-axis.}

\item{font}{Font of the label.}

\item{cex}{Font size of the label}

\item{col.text}{Color of the label.}

\item{len.flag}{Length of the flag.}

\item{lty.flag}{Line-typ of the flag. Value is 1 if not spezified.}

\item{lwd.flag}{Line-wide of the flag. Value is 1 if not spezified.}

\item{bgcol.flag}{Background-color of the flag (corresponding to the 
color of the confidence interval in the plot). No color if not value is
specified.}

\item{lncol.flag}{Color of the line of the flag. Default is "black".}
}
\value{
Draws the number at risk to an existing plot.
}
\description{
This function adds a text label to the plot, which is preceded by a 
small identifier, similar to the function nrAtRisk.
}
\examples{
  require(survival)
  aml_model <- with(aml, survfit(Surv(time, status)~x))
  col1 <- adjustcolor("red",0.2); col2 <- adjustcolor("blue",0.2)
  survPlot(xmax=50)
  confIntArea(aml_model, col=col1, group=1)
  confIntArea(aml_model, col=col2, group=2)
  survCurve(aml_model, group=1)
  survCurve(aml_model, group=2, lty=2)
  survLable("maintain", 1, 0.2, bgcol.flag=col1)
  survLable("non-maint.", 1, 0.1, bgcol.flag=col2, lty.flag=2)
}
