% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_02.r
\name{constraint}
\alias{constraint}
\title{Sum-to-zero constraint}
\usage{
constraint(X, S, Z = NULL)
}
\arguments{
\item{X}{A design matrix}

\item{S}{A penalty matrix or a list of penalty matrices}

\item{Z}{A list of sum-to-zero constraint matrices; default is NULL}
}
\value{
List of objects with the following items:
\item{X}{Design matrix}
\item{S}{Penalty matrix or list of penalty matrices}
\item{Z}{List of sum-to-zero constraint matrices}
}
\description{
Applies the sum-to-zero constraints to design and penalty matrices.
}
\examples{

library(survPen)

set.seed(15)

X <- matrix(rnorm(10*3),nrow=10,ncol=3)
S <- matrix(rnorm(3*3),nrow=3,ncol=3) ; S <- 0.5*( S + t(S))

# applying sum-to-zero constraint to a desgin matrix and a penalty matrix
constr <- constraint(X,S) 

}
