% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_init.R
\name{msplinemodel_init}
\alias{msplinemodel_init}
\title{Create an M-spline survival model, both structure and parameters.}
\usage{
msplinemodel_init(
  df = 10,
  degree = 3,
  bsmooth = TRUE,
  knots = NULL,
  bknot = 10,
  obstimes = NULL,
  coefs = NULL,
  hscale = 1
)
}
\arguments{
\item{df}{Desired number of basis terms, or "degrees of freedom"
in the spline.  If \code{knots} is not supplied, the number of
knots is then chosen to satisfy this.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{knots}{Vector of knot locations. If not supplied, \code{df}
has to be specified.  One of two rules is then used to choose the
knot locations.  If \code{bknot} is specified, a set of equally
spaced knots between zero and \code{bknot} is used.  Otherwise
if \code{obstimes} is supplied, the knots are chosen as equally
spaced quantiles of \code{obstimes}.

The number of knots (excluding zero) is \code{df - degree + 1} if
\code{bsmooth} is \code{TRUE}, or \code{df - degree - 1}
otherwise.}

\item{bknot}{Location of the final spline knot.}

\item{obstimes}{Vector of observation times whose quantiles will be
used to choose knot locations}

\item{coefs}{Basis coefficients}

\item{hscale}{Hazard scale parameter}
}
\value{
A list defining the M-spline, with any omitted list
components set to defaults.  See \code{\link{mspline_init}} for
details.  The parameters are included as the \code{coefs} and
\code{hscale} components.
}
\description{
\code{\link{mspline_init}} is first used to create the M-spline
model structure, including knot positions.  Parameters including
basis coefficients and scale are either supplied or set to a
default that defines a constant hazard model.
}
\details{
This function is not for fitting models to data, but for setting
up a theoretical M-spline model for illustration.
}
