% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_sample_hazard}
\alias{prior_sample_hazard}
\alias{plot_prior_hazard}
\title{Generate and/or plot a sample from the prior distribution of M-spline hazard curves}
\usage{
prior_sample_hazard(
  knots = NULL,
  df = 10,
  degree = 3,
  bsmooth = TRUE,
  coefs_mean = NULL,
  prior_hsd = p_gamma(2, 1),
  prior_hscale = NULL,
  smooth_model = "exchangeable",
  prior_loghr = NULL,
  formula = NULL,
  cure = NULL,
  nonprop = NULL,
  newdata = NULL,
  newdata0 = NULL,
  prior_hrsd = NULL,
  tmin = 0,
  tmax = 10,
  nsim = 10
)

plot_prior_hazard(
  knots = NULL,
  df = 10,
  degree = 3,
  bsmooth = TRUE,
  coefs_mean = NULL,
  prior_hsd = p_gamma(2, 1),
  prior_hscale = p_normal(0, 20),
  smooth_model = "random_walk",
  prior_loghr = NULL,
  formula = NULL,
  cure = NULL,
  nonprop = NULL,
  newdata = NULL,
  prior_hrsd = p_gamma(2, 1),
  tmin = 0,
  tmax = NULL,
  nsim = 10
)
}
\arguments{
\item{knots}{Vector of knot locations. If not supplied, \code{df}
has to be specified.  One of two rules is then used to choose the
knot locations.  If \code{bknot} is specified, a set of equally
spaced knots between zero and \code{bknot} is used.  Otherwise
if \code{obstimes} is supplied, the knots are chosen as equally
spaced quantiles of \code{obstimes}.

The number of knots (excluding zero) is \code{df - degree + 1} if
\code{bsmooth} is \code{TRUE}, or \code{df - degree - 1}
otherwise.}

\item{df}{Desired number of basis terms, or "degrees of freedom"
in the spline.  If \code{knots} is not supplied, the number of
knots is then chosen to satisfy this.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{coefs_mean}{Spline basis coefficients that define the prior
mean for the hazard function. By default, these are set to values
that define a constant hazard function (see
\code{\link{mspline_constant_coefs}}).  They are normalised to
sum to 1 internally (if they do not already).}

\item{prior_hsd}{Gamma prior for the standard deviation that
controls the variability over time (or smoothness) of the hazard
function.  This should be a call to \code{p_gamma()}.  The default is
\code{p_gamma(2,1)}.  See \code{\link{prior_haz_sd}} for a way to
calibrate this to represent a meaningful belief.}

\item{prior_hscale}{Prior for the baseline log hazard scale
parameter (\code{alpha} or \code{log(eta)}).  This should be a call to a
prior constructor function, such as \code{p_normal(0,1)} or
\code{p_t(0,2,2)}.  Supported prior distribution families are normal
(parameters mean and SD) and t distributions (parameters
location, scale and degrees of freedom).  The default is a normal
distribution with mean 0 and standard deviation 20.

Note that \code{eta} is not in itself a hazard, but it is proportional
to the hazard (see the vignette for the full model specification).

"Baseline" is defined by the continuous covariates taking a value
of zero and factor covariates taking their reference level.  To
use a different baseline, the data should be transformed
appropriately beforehand, so that a value of zero has a different
meaning.  For continuous covariates, it helps for both
computation and interpretation to define the value of zero to
denote a typical value in the data, e.g. the mean.}

\item{smooth_model}{The default \code{"random_walk"}, specifies a random walk
prior for the multinomial-logit spline coefficients, based on
logistic distributions.  See the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette}
for full details.

The alternative \code{"exchangeable"} uses
independent logistic priors on the multinomial-logit spline
coefficients, conditionally on a common smoothing variance
parameter.  Note this is the method explained in the original
survextrap paper (Jackson, BMC Med Res 2023).  The random
walk model is shown to perform better in Timmins et al (2025).

In non-proportional hazards models, setting \code{smooth_model} also
determines whether an exchangeable or random walk model is used for the
non-proportionality parameters (\eqn{\delta}).}

\item{prior_loghr}{Priors for log hazard ratios.  This should be a
call to \code{p_normal()} or \code{p_t()}.  A list of calls can also be
provided, to give different priors to different coefficients,
where the name of each list component matches the name of the
coefficient, e.g.  \code{list("age45-59" = p_normal(0,1), "age60+" = p_t(0,2,3))}

The default is \code{p_normal(0,2.5)} for all coefficients.}

\item{formula}{A survival formula in standard R formula syntax, with a call to \code{Surv()}
on the left hand side.

Covariates included on the right hand side of the formula with be
modelled with proportional hazards, or if \code{nonprop} is
\code{TRUE} then a non-proportional hazards is used.

If \code{data} is omitted, so that the model is being fitted to
external aggregate data alone, without individual data, then the
formula should not include a \code{Surv()} call.  The left-hand
side of the formula will then be empty, and the right hand side
specifies the covariates as usual.  For example, \code{formula =
~1} if there are no covariates.}

\item{cure}{If \code{TRUE}, a mixture cure model is used, where the
"uncured" survival is defined by the M-spline model, and the cure
probability is estimated.}

\item{nonprop}{Non-proportional hazards model specification.
This is achieved by modelling the spline basis coefficients in terms of the covariates.  See
the \href{https://chjackson.github.io/survextrap/articles/methods.html}{methods vignette} for more details.

If \code{TRUE}, then all covariates are modelled with
non-proportional hazards, using the same model formula as
\code{formula}.

If this is a formula, then this is assumed to define a model for
the dependence of the basis coefficients on the covariates.

IF this is \code{NULL} or \code{FALSE} (the default) then any
covariates are modelled with proportional hazards.}

\item{newdata}{A data frame with one row, containing variables in
the model formulae.  Samples will then be drawn, for any
covariate-dependent parameters, with covariates set to the
values given here.}

\item{newdata0}{A data frame with one row, containing "reference"
values of variables in the model formulae.  The hazard ratio
between the hazards at \code{newdata} and \code{newdata0} will
be returned.}

\item{prior_hrsd}{Prior for the standard deviation parameters that
smooth the non-proportionality effects over time in
non-proportional hazards models.  This should be a call to
\code{p_gamma()} or a list of calls to \code{p_gamma()} with one component
per covariate, as in \code{prior_loghr}.  See
\code{\link{prior_hr_sd}} for a way to calibrate this to
represent a meaningful belief.}

\item{tmin}{Minimum plotting time.  Defaults to zero.}

\item{tmax}{Maximum plotting time.  Defaults to the highest knot.}

\item{nsim}{Number of simulations to draw}
}
\value{
A tidy data frame containing values of the hazard at a
sequence of times, for different draws from the prior distribution.
}
\description{
Generates and/or plots the hazard curves (as functions of time)
implied by a prior mean for the spline coefficients (a constant
hazard by default) and particular priors for the baseline log
hazard and smoothness standard deviation.
}
