% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_nav}
\alias{sd_nav}
\title{Create Navigation Buttons for Survey Pages}
\usage{
sd_nav(
  page_next = NULL,
  label_previous = NULL,
  label_next = NULL,
  show_previous = NULL,
  show_next = TRUE
)
}
\arguments{
\item{page_next}{Character string. The ID of the next page to navigate to when
the Next button is clicked. If \code{NULL}, the survey will navigate to the default
next page in sequence.}

\item{label_previous}{Character string. The label for the 'Previous' button. Defaults
to \code{NULL}, which uses "← Previous" (or the translated equivalent).}

\item{label_next}{Character string. The label for the 'Next' button. Defaults
to \code{NULL}, which uses "Next →" (or the translated equivalent).}

\item{show_previous}{Logical. Whether to show the Previous button. Set to \code{FALSE}
for the first page where there is no previous page to navigate to. If \code{NULL}
(default), uses the \code{show-previous} setting from YAML or \code{sd_server()}.}

\item{show_next}{Logical. Whether to show the Next button. Set to \code{FALSE}
to hide the Next button. Defaults to \code{TRUE}.}
}
\value{
A 'shiny' tagList containing the navigation buttons UI elements.
}
\description{
This function creates both 'Previous' and 'Next' buttons for navigating between
pages in a surveydown survey. The buttons are positioned on the left (Previous)
and right (Next) of the page. The Previous button allows users to return to
previously visited pages, while the Next button maintains the standard forward
navigation behavior.
}
\details{
The function generates two 'shiny' action buttons:
\itemize{
\item \strong{Previous button:} Positioned on the left, navigates to the last
visited page. Uses page history tracking to determine the previous page.
\item \strong{Next button:} Positioned on the right, navigates forward. Can be
activated by clicking or pressing the Enter key when visible.
}

The buttons are styled to appear on opposite sides of the page using flexbox
layout, and include arrow symbols to indicate direction.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Basic usage with both buttons
  sd_nav()

  # First page - hide Previous button
  sd_nav(show_previous = FALSE)

  # Last page - hide Next button
  sd_nav(show_next = FALSE)

  # Hide both navigation buttons
  sd_nav(show_previous = FALSE, show_next = FALSE)

  # Custom labels
  sd_nav(
    label_previous = "Go Back",
    label_next = "Continue"
  )

  # Specify next page explicitly
  sd_nav(page_next = "demographics")
}

}
\seealso{
\code{\link{sd_next}} for the legacy single-button navigation (deprecated)
}
