% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid.R
\name{hybridFit}
\alias{hybridFit}
\title{survivalsvm (hybrid approach)}
\usage{
hybridFit(
  X,
  Y,
  delta,
  meth_par = c(1, 1),
  kernel_type = "lin_kernel",
  kernel_pars = NA,
  bin_cat = integer(0),
  makediff = makediff3,
  opt_alg = "quadprog",
  sgf_sv = 5,
  sigf = 7,
  maxiter = 40,
  margin = 0.05,
  bound = 10,
  eig.tol = 1e-06,
  conv.tol = 1e-07,
  posd.tol = 1e-08
)
}
\arguments{
\item{X}{[\code{matrix(1)}]\cr
Matrix of training data points.}

\item{Y}{[\code{vector(1)}]\cr
Vector of survival times.}

\item{delta}{[\code{vector(1)}]\cr
Vector of status: 1 = not censored.}

\item{meth_par}{[\code{numeric(1)}]\cr
Parameters of regularization.}

\item{kernel_type}{[\code{character(1)}]\cr
Kernel that is used to fit the model. The handled type are: linear kern ('lin_kern'), additive kernel ('add_kernel'),
radial basis kernels ('rbf_kernel' and 'rbf4_kernel') and the polynomial kernel ('poly_kernel').}

\item{kernel_pars}{[\code{numeric(1)|vector(1)}]\cr
Parameters of kernel, when required.}

\item{bin_cat}{[\code{vector(1)}]\cr
Indexes of binary/categorical varibales}

\item{makediff}{[\code{character(1)}]\cr
String indicating which of \code{'makediff1'}, \code{'makediff2'} or \code{'makediff3'}
will be used.}

\item{opt_alg}{[\code{character(1)}]\cr
Program that will be used to solve the quadratic optimization problem. Either \code{\link[pracma]{quadprog}} or \code{\link[kernlab]{ipop}}.}

\item{sgf_sv}{[\code{integer(1)}]\cr
Number of decimal digits in the solution of the quadratic optimization problem.}

\item{sigf}{[\code{integer(1)}]\cr
Used by \code{\link[kernlab]{ipop}}. See \code{\link[kernlab]{ipop}} for details.}

\item{maxiter}{[\code{integer(1)}]\cr
Used by \code{\link[kernlab]{ipop}}. See \code{\link[kernlab]{ipop}} for details.}

\item{margin}{[\code{numeric(1)}]\cr
Used by \code{\link[kernlab]{ipop}}. See \code{\link[kernlab]{ipop}} for details.}

\item{bound}{[\code{numeric(1)}]\cr
Used by \code{\link[kernlab]{ipop}}. See \code{\link[kernlab]{ipop}} for details.}

\item{eig.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}

\item{conv.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}

\item{posd.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}
}
\value{
[\code{Hybrid(1)}]
Object of class \code{Hybrid} containing elements:
\tabular{ll}{
   \code{Alpha} \tab Solution of the quadratic optimization problem, \cr
   \code{Xtrain} \tab Matrix of training points,\cr
   \code{DifMat} \tab Matrix used to maked differences between neighbor points, \cr
   \code{Kernel} \tab Kernel matrix, an object of class \code{Kernel},\cr
   \code{OptMeth} \tab Program used to solve the quadratic optimization problem.\cr
 }
}
\description{
fits survivalsvm model based on hybrid approach method for survival support vector ananlysis.
}
\author{
Cesaire J. K. Fouodo
}
\keyword{internal}
