% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{tau_star}
\alias{tau_star}
\title{Calculates parameter \eqn{\tau^*_i} of \eqn{q^*(\gamma_i)} for
\eqn{i=1,...,K} clusters to optimize the evidence based lower bound
(ELBO) in \code{survregVB.frailty.fit}.}
\usage{
tau_star(y, X, delta, alpha, omega, mu, tau, sigma, expectation_b, cluster)
}
\arguments{
\item{y}{A vector of observed log-transformed survival times.}

\item{X}{A design matrix including covariates with first column of ones
to represent the intercept.}

\item{delta}{A binary vector indicating right censoring.}

\item{alpha}{The shape parameter \eqn{\alpha^*} of \eqn{q^*(b)}.}

\item{omega}{The scale parameter \eqn{\omega^*} of \eqn{q^*(b)}.}

\item{mu}{Parameter \eqn{\mu^*} of \eqn{q^*(\beta)}, a vector of means.}

\item{tau}{Parameter \eqn{\tau^*} of \eqn{q^*(\gamma_i)}, a vector of
means.}

\item{sigma}{Parameter \eqn{\sigma^{2*}_i} of \eqn{q^*(\gamma_i)}, a
vector of variance.}

\item{expectation_b}{The expected value of \emph{b}.}

\item{cluster}{A numeric vector indicating the cluster assignment for
each observation.}
}
\value{
Parameter vector \eqn{\tau^*_i} of \eqn{q^*(\gamma_i)} for
\eqn{i=1,...,K} clusters.
}
\description{
Calculates parameter \eqn{\tau^*_i} of \eqn{q^*(\gamma_i)} for
\eqn{i=1,...,K} clusters to optimize the evidence based lower bound
(ELBO) in \code{survregVB.frailty.fit}.
}
\seealso{
\code{\link{survregVB.frailty.fit}}
}
