% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_list.tcltkGUI.R
\name{dlg_list.tcltkGUI}
\alias{dlg_list.tcltkGUI}
\title{A Tcl/Tk version of the \{svDialogs\} list selection dialog box}
\usage{
\method{dlg_list}{tcltkGUI}(
  choices,
  preselect = NULL,
  multiple = FALSE,
  title = NULL,
  ...,
  gui = .GUI
)
}
\arguments{
\item{choices}{The list of items. It is coerced to character strings.}

\item{preselect}{A list of preselections, or \code{NULL} (then, the first element
is selected in the list). Preselections not in choices are tolerated (but
they are ignored without warning or error).}

\item{multiple}{Is it a multiple selection dialog box?}

\item{title}{The title of the dialog box, or \code{NULL} to use a default title
instead.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
A character vector with the items that were selected by the user.
}
\description{
A Tcl/Tk version of the \{svDialogs\} list selection dialog box
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# Select one or several months
res <- dlg_list(month.name, multiple = TRUE)$res
if (!length(res)) {
  cat("You cancelled the choice\n")
} else {
  cat("You selected:\n")
  print(res)
}
}
}
\seealso{
\code{\link[svDialogs:dlg_list]{svDialogs::dlg_list()}}
}
\concept{Modal dialog box}
\keyword{misc}
