% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wocp.R
\name{wocp}
\alias{wocp}
\title{Optimal cut-off points for complex survey data}
\usage{
wocp(
  response.var,
  phat.var,
  weights.var = NULL,
  tag.event = NULL,
  tag.nonevent = NULL,
  method = c("Youden", "MaxProdSpSe", "ROC01", "MaxEfficiency"),
  data = NULL,
  design = NULL
)
}
\arguments{
\item{response.var}{A character string with the name of the column indicating the response variable in the data set
or a vector (either numeric or character string) with information of the response variable for all the units.}

\item{phat.var}{A character string with the name of the column indicating the estimated probabilities in the data set
or a numeric vector containing estimated probabilities for all the units.}

\item{weights.var}{A character string indicating the name of the column with sampling weights or
a numeric vector containing information of the sampling weights.
It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.
For unweighted estimates, set all the sampling weight values to 1.}

\item{tag.event}{A character string indicating the label used to indicate the event of interest in \code{response.var}.
The default option is \code{tag.event = NULL}, which selects the class with the lowest number of units as event.}

\item{tag.nonevent}{A character string indicating the label used for non-event in \code{response.var}.
The default option is \code{tag.nonevent = NULL}, which selects the class with the greatest number of units as non-event.}

\item{method}{A character string indicating the method to be used to select the optimal cut-off point.
Choose one of the following methods (Lopez-Raton et al, 2014):
\code{MaxProdSpSe}, \code{ROC01}, \code{Youden}, \code{MaxEfficiency}.}

\item{data}{A data frame which, at least, must incorporate information on the columns
\code{response.var}, \code{phat.var} and \code{weights.var}.
If \code{data=NULL}, then specific numerical vectors must be included in
\code{response.var}, \code{phat.var} and \code{weights.var},
or the sampling design should be indicated in the argument \code{design}.}

\item{design}{An object of class \code{survey.design} generated by
\code{survey::svydesign} indicating the complex sampling design of the data.
If \code{design = NULL}, information on the data set (argument \code{data})
and/or sampling weights (argument \code{weights.var}) must be included.}
}
\value{
The output of this function is an object of class \code{wocp}. This object is a list that contains information about the following 4 elements:
\itemize{
\item \code{tags}: a list containing two elements with the following information:
\itemize{
\item \code{tag.event}: a character string indicating the event of interest.
\item \code{tag.nonevent}: a character string indicating the non-event.
}
\item \code{basics}: a list containing information of the following 4 elements:
\itemize{
\item \code{n.event}: number of units with the event of interest in the data set.
\item \code{n.nonevent}: number of units without the event of interest in the data set.
\item \code{hatN.event}: number of units with the event of interest represented in the population by all the event units in the data set, i.e., the sum of the sampling weights of the units with the event of interest in the data set.
\item \code{hatN.nonevent}: a numeric value indicating the number of non-event units in the population represented by means of the non-event units in the data set, i.e., the sum of the sampling weights of the non-event units in the data set.
}
\item \code{optimal.cutoff}: this object is a list of three elements containing the information described below:
\itemize{
\item \code{method}: a character string indicating the method implemented to select the optimal cut-off point.
\item \code{optimal}: a list containing information of the following four elements:
\itemize{
\item \code{cutoff}: a numeric vector indicating the optimal cut-off point(s) that optimize(s) the selected criterion.
\item \code{Sew}: a numeric vector indicating the estimated sensitivity parameter(s) corresponding to the optimal cut-off point(s) that optimize(s) the selected criterion.
\item \code{Spw}: a numeric vector indicating the estimated specificity parameter(s) corresponding to the optimal cut-off point(s) that optimize(s) the selected criterion.
\item \code{criterion}: a numeric value indicating the criterion value optimized by means of the selected optimal cut-off point(s).
}
\item \code{all}: a list containing information on the following four elements:
\itemize{
\item \code{cutoff}: a numeric vector indicating all the cut-off points considered.
\item \code{Sew}: a numeric vector indicating the estimated sensitivity parameters corresponding to all the considered cut-off points.
\item \code{Spw}: a numeric vector indicating the estimated sensitivity parameters corresponding to all the considered cut-off points.
\item \code{criterion}: a numeric vector indicating the values of the selected criterion corresponding to all the considered cut-off points.
}
}
\item \code{call}: an object saving the information about the way in which the function has been run.
}
}
\description{
Calculate optimal cut-off points for complex survey data (Iparragirre et al., 2022).
Some functions of the package OptimalCutpoints (Lopez-Raton et al, 2014) have been used and modified in order them to consider sampling weights.
}
\details{
Let \eqn{S} indicate a sample of \eqn{n} observations of the vector of random variables \eqn{(Y,\pmb X)}, and \eqn{\forall i=1,\ldots,n,} \eqn{y_i} indicate the \eqn{i^{th}} observation of the response variable \eqn{Y},
and \eqn{\pmb x_i} the observations of the vector covariates \eqn{\pmb X}. Let \eqn{w_i} indicate the sampling weight corresponding to the unit \eqn{i} and \eqn{\hat p_i} the estimated probability of event.
Let \eqn{S_0} and \eqn{S_1} be subsamples of \eqn{S}, formed by the units without the event of interest (\eqn{y_i=0}) and with the event of interest (\eqn{y_i=1}), respectively.
Then, the optimal cut-off points are obtained as follows:
\itemize{
\item \code{Youden}: \deqn{c_w^{\text{Youden}}=argmax_c\{\widehat{Se}_w(c) + \widehat{Sp}_w(c)-1\},}
\item \code{MaxProdSpSe}: \deqn{c_w^{\text{MaxProdSpSe}}=argmax_c\{\widehat{Se}_w(c) * \widehat{Sp}_w(c)\},}
\item \code{ROC01}: \deqn{c_w^{\text{ROC01}}=argmax_c\{(\widehat{Se}_w(c)-1)^2 + (\widehat{Sp}_w(c)-1)^2\},}
\item \code{MaxEfficiency}: \deqn{c_w^{\text{MaxEfficiency}}=argmax_c\{\hat p_{Y,w}\widehat{Se}_w(c) + (1-\hat p_{Y,w})\widehat{Sp}_w(c)\},}
}

where, the sensitivity and specificity parameters for a given cut-off point \eqn{c} are estimated as follows:
\deqn{\widehat{Se}_w(c)=\dfrac{\sum_{i\in S_1}w_i\cdot I (\hat p_i\geq c)}{\sum_{i\in S_1}w_i}\:;\:\widehat{Sp}_w(c)=\dfrac{\sum_{i\in S_0}w_i\cdot I (\hat p_i<c)}{\sum_{i\in S_0}w_i},}
and,
\deqn{\hat p_{Y,w}=\dfrac{\sum_{i\in S} w_i\cdot I(y_i=1)}{\sum_{i\in S} w_i}.}

See Iparragirre et al. (2022) and Lopez-Raton et al. (2014) for more information.
}
\examples{
data(example_data_wroc)

myocp <- wocp(response.var = "y", phat.var = "phat", weights.var = "weights",
              tag.event = 1, tag.nonevent = 0,
              method = "Youden",
              data = example_data_wroc)

# Or equivalently
myocp <- wocp(example_data_wroc$y, example_data_wroc$phat, example_data_wroc$weights,
              tag.event = 1, tag.nonevent = 0, method = "Youden")


}
\references{
Iparragirre, A., Barrio, I., Aramendi, J. and Arostegui, I. (2022). Estimation of cut-off points under complex-sampling design data. \emph{SORT-Statistics and Operations Research Transactions} \bold{46}(1), 137--158.

Lopez-Raton, M., Rodriguez-Alvarez, M.X, Cadarso-Suarez, C. and Gude-Sampedro, F. (2014). OptimalCutpoints: An R Package for Selecting Optimal Cutpoints in Diagnostic Tests. \emph{Journal of Statistical Software} \bold{61}(8), 1--36.
}
