% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.swaglm_test.R
\name{print.swaglm_test}
\alias{print.swaglm_test}
\title{print.swaglm_test}
\usage{
\method{print}{swaglm_test}(x, ...)
}
\arguments{
\item{x}{An object of class \code{swaglm_test}.}

\item{...}{Additional arguments}
}
\value{
None.
}
\description{
Print a \code{swaglm_test} object
}
\examples{
n <- 2000
p <- 50

# create design matrix and vector of coefficients
Sigma <- diag(rep(1/p, p))
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma)
beta = c(-15,-10,5,10,15, rep(0,p-5))
z <- 1 + X\%*\%beta
pr <- 1/(1 + exp(-z))
y <- as.factor(rbinom(n, 1, pr))
y = as.numeric(y)-1
quantile_alpha = .15
p_max = 20
swag_obj = swaglm::swaglm(X=X, y = y, p_max = p_max, family = stats::binomial(),
                          alpha = quantile_alpha, verbose = TRUE, seed = 123)
swag_test = swaglm::swaglm_test(swag_obj, B = 10, verbose = TRUE)
swag_test
}
