% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JacobianRAM.R
\name{JacobianRAM}
\alias{JacobianRAM}
\title{Compute a Jacobian Matrix of the Implied Covariance/Correlation Matrix based on a RAM model.}
\usage{
JacobianRAM(RAM, vars, corr = FALSE)
}
\arguments{
\item{RAM}{A RAM object including a list of matrices of the model returned
from \code{\link[metaSEM]{lavaan2RAM}}}

\item{vars}{A vector of characters of the random variables. If the random
variables are not listed in `vars`, they are treated as constants. If `vars`
is missing, all names in `RAM` are treated as random variables.}

\item{corr}{Whether the model implied matrix is covariance (default) or
correlation structure.}
}
\value{
A Jacobian matrix.
}
\description{
It computes a symbolic Jacobian matrix of the model-implied covariance (or correlation) matrix in
SEM using the RAM specification.
}
\examples{
\dontrun{

#### A mediation model
model1 <- "y ~ c*x + b*m
           m ~ a*x
           ## Means
           y ~ b0*1
           m ~ m0*1
           x ~ x0*1"

RAM1 <- metaSEM::lavaan2RAM(model1)

## Model-implied covariance matrix and mean structure
JacobianRAM(RAM1, corr=FALSE)

## Model-implied correlation matrix
JacobianRAM(RAM1, corr=TRUE)

#### A CFA model
model2 <- "f =~ x1 + x2 + x3 + x4#'
           ## Mean
           f ~ fmean*1"

RAM2 <- metaSEM::lavaan2RAM(model2)

## Model-implied covariance matrix
JacobianRAM(RAM2, corr=FALSE)

## Model-implied correlation matrix
JacobianRAM(RAM2, corr=TRUE)
}
}
\author{
Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>
}
