% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_refs.R
\name{write_bib}
\alias{write_bib}
\alias{write_ris}
\alias{write_refs}
\title{Export data to a bibliographic format}
\usage{
write_bib(x)

write_ris(x, tag_naming = "synthesisr")

write_refs(x, format = "ris", tag_naming = "synthesisr", file = FALSE)
}
\arguments{
\item{x}{Either a data.frame containing bibliographic information or an object of class bibliography.}

\item{tag_naming}{what naming convention should be used to write RIS files? See details for options.}

\item{format}{What format should the data be exported as? Options are ris or bib.}

\item{file}{Either logical indicating whether a file should be written (defaulting to FALSE), or a character giving the name of the file to be written.}
}
\value{
Returns a character vector containing bibliographic information in the specified format if \code{file} is FALSE, or saves output to a file if TRUE.
}
\description{
This function exports data.frames containing bibliographic information to either a .ris or .bib file.
}
\section{Functions}{
\itemize{
\item \code{write_bib}: Format a bib file for export

\item \code{write_ris}: Format a ris file for export
}}

\examples{
eviatlas <- c(
  "TY  - JOUR",
  "AU  - Haddaway, Neal R.",
  "AU  - Feierman, Andrew",
  "AU  - Grainger, Matthew J.",
  "AU  - Gray, Charles T.",
  "AU  - Tanriver-Ayder, Ezgi",
  "AU  - Dhaubanjar, Sanita",
  "AU  - Westgate, Martin J.",
  "PY  - 2019",
  "DA  - 2019/06/04",
  "TI  - EviAtlas: a tool for visualising evidence synthesis databases",
  "JO  - Environmental Evidence",
  "SP  - 22",
  "VL  - 8",
  "IS  - 1",
  "SN  - 2047-2382",
  "UR  - https://doi.org/10.1186/s13750-019-0167-1",
  "DO  - 10.1186/s13750-019-0167-1",
  "ID  - Haddaway2019",
  "ER  - "
)

detect_parser(eviatlas) # = "parse_ris"
df <- as.data.frame(parse_ris(eviatlas))
ris_out <- write_refs(df, format = "ris", file = FALSE)
}
