% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabmedians.R
\name{tabmedians}
\alias{tabmedians}
\title{Create Table Comparing Group Medians}
\usage{
tabmedians(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  columns = c("xgroups", "p"),
  parenth = "iqr",
  sep.char = ", ",
  xlevels = NULL,
  yname = NULL,
  text.label = NULL,
  quantiles = NULL,
  quantile.vals = FALSE,
  decimals = NULL,
  formatp.list = NULL,
  n.headings = TRUE,
  kable = TRUE
)
}
\arguments{
\item{formula}{Formula, e.g. \code{BMI ~ Group}.}

\item{data}{Data frame containing variables named in \code{formula}.}

\item{x}{Vector of values for the categorical \code{x} variable.}

\item{y}{Vector of values for the continuous \code{y} variable.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for total sample size, \code{"overall"} for
overall median, \code{"xgroups"} for \code{x} group medians, \code{"diff"}
for difference in \code{x} group medians (only available for binary
\code{x}), \code{"test"} for test statistic, and \code{"p"} for p-value.}

\item{parenth}{Character string specifying what values are shown in
parentheses after the medians in each cell. Choices are \code{"none"},
\code{"iqr"}, \code{"q1q3"} for first and third quartiles, \code{"range"},
\code{"minmax"}, and \code{"ci"} for 95\% confidence interval for the medians
based on normal approximation to binomial.}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yname}{Character string with a label for the \code{y} variable.}

\item{text.label}{Character string with text to put after the \code{y}
variable name, identifying what cell values and parentheses represent.}

\item{quantiles}{Numeric value. If specified, table compares \code{y} across
quantiles of \code{x} created on the fly.}

\item{quantile.vals}{Logical value for whether labels for \code{x} quantiles
should show quantile number and corresponding range, e.g. Q1 [0.00, 0.25),
rather than just the quantile number.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display group sample sizes in
parentheses in column headings.}

\item{kable}{Logical value for whether to return a
\code{\link[knitr]{kable}}.}
}
\value{
\code{\link[knitr]{kable}}.
}
\description{
Creates a table comparing the median of \code{y} across levels of \code{x}.
}
\details{
If \code{x} has 2 levels, a Mann-Whitney U (also known as Wilcoxon
rank-sum) test is used to test whether the distribution of \code{y} differs
in the two groups; if \code{x} has more than 2 levels, a Kruskal-Wallis test
is used to test whether the distribution of \code{y} differs across at
least two of the groups. Observations with missing values for \code{x} and/or
\code{y} are dropped.
}
\examples{
# Compare median BMI in control group vs. treatment group in sample dataset
(medtable1 <- tabmedians(BMI ~ Group, data = tabdata))

# Compare median baseline systolic BP across tertiles of BMI
(medtable2 <- tabmedians(bp.1 ~ BMI, data = tabdata,
                         quantiles = 3, yname = "Systolic BP"))


}
