
summary.tbcmp_compare <- function(comp) {
  diff_inds <-
    comp$summ[,  .(i_a = nested_dt_pull(value_diffs, i_a)), column]
  n_diffs <-
    diff_inds[, .(row_diff = uniqueN(i_a), col_diff = uniqueN(column))] %>%
    .[, .(table = comp$tables$table), .(row_diff, col_diff)]
  n_unmatch <-
    merge(
      comp$unmatched_rows[, .(row_nomatch = .N), table],
      comp$unmatched_cols[, .(col_nomatch = .N), table],
      by = "table"
    )

  out <- comp$tables %>%
    merge(n_diffs, by = "table", all = TRUE) %>%
    merge(n_unmatch, by = "table", all = TRUE) %>%
    .[, .(table, name,
      nrow,
      row_diff = fcoalesce(row_diff, 0L),
      row_nomatch = fcoalesce(row_nomatch, 0L),
      ncol,
      col_diff = fcoalesce(col_diff, 0L),
      col_nomatch = fcoalesce(col_nomatch, 0L)
    )]
  out
}
