% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss.R
\name{nn_aum_loss}
\alias{nn_aum_loss}
\title{AUM loss}
\usage{
nn_aum_loss()
}
\description{
Creates a criterion that measures the Area under the \eqn{Min(FPR, FNR)} (AUM) between each
element in the input \eqn{pred_tensor} and target \eqn{label_tensor}.
}
\details{
This is used for measuring the error of a binary reconstruction within highly unbalanced dataset,
where the goal is optimizing the ROC curve. Note that the targets \eqn{label_tensor} should be factor
level of the binary outcome, i.e. with values \code{1L} and \code{2L}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
loss <- nn_aum_loss()
input <- torch::torch_randn(4, 6, requires_grad = TRUE)
target <- input > 1.5
output <- loss(input, target)
output$backward()
\dontshow{\}) # examplesIf}
}
