% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tac_methods.R
\name{as.tac}
\alias{as.tac}
\title{Creates a tac object from a data.frame}
\usage{
as.tac(x, time_unit = NULL, activity_unit = NULL)
}
\arguments{
\item{x}{data.frame with start, end time and tac data}

\item{time_unit}{NULL if in data.frame or set to "seconds" or "minutes"}

\item{activity_unit}{NULL if in data.frame or set to "kBq/cc", "Bq/cc", 
"nCi/cc"}
}
\value{
tac object
}
\description{
tac objects can be created from data.frame objects with `as.tac()`. The time 
and activity units must be specified as arguments if not already set as 
attributes in the data.frame. The columns of the data frame are the regional
time activity curves, with the column names the names of the ROIs.
}
\details{
If the time_unit and activity_unit attributes are already in the data.frame,
they do not need to be set again, but otherwise they will need to be
specified in the input parameters.
}
\examples{
manual <- data.frame(start=c(0:4), end=c(2:6), 
                     ROI1=c(10.1:14.2), ROI2=c(11:15))
manual_tac <- as.tac(manual, time_unit="minutes", activity_unit="kBq/cc")
}
\seealso{
Other Loading functions: 
\code{\link{load_tac}()},
\code{\link{load_voistat}()},
\code{\link{load_vol}()}
}
\concept{Loading functions}
