% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batches.R
\name{batch_voistat}
\alias{batch_voistat}
\title{Obtain values from voistat files (using load_voistat() for a batch.}
\usage{
batch_voistat(
  participants,
  ROI_def,
  dir = "",
  filesuffix = ".voistat",
  varname = "VALUE"
)
}
\arguments{
\item{participants}{A vector of participant IDs}

\item{ROI_def}{Object that defines combined ROIs, see ROI_definitions.R}

\item{dir}{Directory and/or filename prefix of the files}

\item{filesuffix}{Optional filename characters between ID and ".voistat"}

\item{varname}{The name of the variable being extracted, e.g. "SRTM"}
}
\value{
A table of values for the specified ROIs for all participants
}
\description{
For a vector of participant IDs and correspondingly named .voistat files,
this extracts the value from the files for the specified ROIs.
participants can also be a vector of filenames, in which case set dir="" and
filesuffix="", as in the example.
}
\details{
See load_voistat() for specifics.
}
\examples{
participants <- c(system.file("extdata", "AD06_BPnd_BPnd_Logan.voistat", 
                              package="tacmagic"),
                   system.file("extdata", "AD07_BPnd_BPnd_Logan.voistat", 
                               package="tacmagic"),
                   system.file("extdata", "AD08_BPnd_BPnd_Logan.voistat", 
                               package="tacmagic"))

batchtest <- batch_voistat(participants=participants, ROI_def=roi_ham_pib(), 
                           dir="", filesuffix="", varname="Logan") 

}
\seealso{
Other Batch functions: 
\code{\link{batch_load}()},
\code{\link{batch_tm}()}
}
\concept{Batch functions}
