% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editor.tagcloud.R
\name{editor.tagcloud}
\alias{editor.tagcloud}
\title{Simple interactive editing of tag clouds}
\usage{
editor.tagcloud(boxes)
}
\arguments{
\item{boxes}{An object of the tagcloud class, returned by the
\code{\link{tagcloud}} function.}
}
\value{
An object of the \code{tagcloud class} with the modified positions
of the tags.
}
\description{
A minimalistic editor for object of the tagcloud class.
}
\details{
\code{tagcloud} provides a minimalistic editor for tag clouds produced by
\code{\link{tagcloud}} function. After \code{editor.tagcloud} is called, the
tag cloud is plotted. First click selects the tag to be moved. The second
click sends the tag such that its left lower corner is at the position
indicated by the mouse. Right-clicking terminates the program.
}
\examples{

\dontrun{
data( gambia )
terms <- gambia$Term
tagcloud( terms )
boxes <- editor.tagcloud( boxes )

}

}
\seealso{
\code{\link{tagcloud}}
}
\author{
January Weiner <january.weiner@gmail.com>
}
\keyword{clouds}
\keyword{editing}
\keyword{tag}
\keyword{tags}
