% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ELT.R
\name{ELT}
\alias{ELT}
\title{Event Loss Table}
\usage{
ELT(X = NULL, Rate = NULL, Loss = NULL, ID = NULL)
}
\arguments{
\item{X}{Data frame containing at least two numeric columns. The column \code{Loss} contains the expected losses from each single occurrence of event. The column \code{Rate} contains the arrival rates of a single occurrence of event.}

\item{Rate}{Positive numeric vector of arrival rates}

\item{Loss}{Positive numeric vector of losses}

\item{ID}{Vector event ID.}
}
\value{
An object ELT, a data frame with 3 columns. The column \code{ID} contains the ID of each event.  The column \code{Rate} contains the arrival rates of a single occurrence of event. The column \code{Loss} contains the expected losses from each single occurrence of event.
}
\description{
Function to create an ELT object
}
\examples{
rate <- c(.1, .02, .05)
loss <- c(2, 5, 7)

ELT(Rate = rate, Loss = loss)
# Same as
rl <- data.frame(Rate = rate, Loss = loss)
ELT(rl)
}
\seealso{
\code{\link{data.frame}}
}

