% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_read_archive.R
\name{tar_read_archive}
\alias{tar_read_archive}
\alias{tar_read_archive_raw}
\title{Read a target's value from archive storage}
\usage{
tar_read_archive(
  name,
  package,
  pipeline,
  branches = NULL,
  meta = NULL,
  store = targets::tar_config_get("store")
)

tar_read_archive_raw(
  name,
  package,
  pipeline,
  branches = NULL,
  meta = NULL,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Name of the target to read.
\code{\link[targets:tar_read]{tar_read()}} expects an
unevaluated symbol for the \code{name} argument, whereas \code{\link[targets:tar_read_raw]{tar_read_raw()}}
expects a character string.}

\item{package}{A scalar character of the package name.}

\item{pipeline}{A scalar character of the pipeline name.}

\item{branches}{Integer of indices of the branches to load
if the target is a pattern.}

\item{meta}{Data frame of metadata from \code{\link[targets:tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[targets:tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[targets:tar_config_get]{tar_config_get()}} and \code{\link[targets:tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
The target's return value from its file in
\verb{_targets/objects/}, or the paths to the custom files and directories
if \code{format = "file"} was set.
}
\description{
Read a target's value from archive storage
}
