% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_github_actions.R
\name{tar_github_actions}
\alias{tar_github_actions}
\title{Set up GitHub Actions to run a targets pipeline}
\usage{
tar_github_actions(
  path = file.path(".github", "workflows", "targets.yaml"),
  ask = NULL
)
}
\arguments{
\item{path}{Character of length 1, file path to write the GitHub Actions
workflow file.}

\item{ask}{Logical, whether to ask before writing if the workflow file
already exists. If \code{NULL}, defaults to \code{Sys.getenv("TAR_ASK")}.
(Set to \code{"true"} or \code{"false"} with \code{Sys.setenv()}).
If \code{ask} and the \code{TAR_ASK} environment variable are both
indeterminate, defaults to \code{interactive()}.}
}
\value{
Nothing (invisibly). This function writes a GitHub Actions
workflow file as a side effect.
}
\description{
Writes a GitHub Actions workflow file so the pipeline
runs on every push to GitHub. Historical runs accumulate in the
\code{targets-runs} branch, and the latest output is restored before
\code{\link[=tar_make]{tar_make()}} so up-to-date targets do not rerun.
}
\details{
Steps to set up continuous deployment:
\enumerate{
\item Ensure your pipeline stays within the resource limitations of
GitHub Actions and repositories, both for storage and compute.
For storage, you may wish to reduce the burden with
an alternative repository (e.g. \code{tar_target(..., repository = "aws")}).
\item Ensure Actions are enabled in your GitHub repository.
You may have to visit the Settings tab.
\item Call \code{targets::tar_renv(extras = character(0))}
to expose hidden package dependencies.
\item Set up \code{renv} for your project (with \code{renv::init()}
or \code{renv::snapshot()}). Details at
\url{https://rstudio.github.io/renv/articles/ci.html}.
\item Commit the \code{renv.lock} file to the \code{main} (recommended)
or \code{master} Git branch.
\item Run \code{tar_github_actions()} to create the workflow file.
Commit this file to \code{main} (recommended) or \code{master} in Git.
\item Push your project to GitHub. Verify that a GitHub Actions
workflow runs and pushes results to \code{targets-runs}.
Subsequent runs will only recompute the outdated targets.
}
}
\examples{
tar_github_actions(tempfile())
}
\seealso{
Other scripts: 
\code{\link{tar_edit}()},
\code{\link{tar_helper}()},
\code{\link{tar_renv}()},
\code{\link{tar_script}()}
}
\concept{scripts}
