% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_custom_format.R
\name{tar_resources_custom_format}
\alias{tar_resources_custom_format}
\title{Target resources for custom storage formats}
\usage{
tar_resources_custom_format(
  envvars = targets::tar_option_get("resources")$custom_format$envvars
)
}
\arguments{
\item{envvars}{Named character vector of environment variables.
These environment variables are temporarily set just before each call to
the storage methods you define in \code{\link[=tar_format]{tar_format()}}. Specific methods
like \code{read} can retrieve values from these environment variables
using \code{Sys.getenv()}. Set \code{envvars} to \code{NULL} to omit entirely.}
}
\value{
Object of class \code{"tar_resources_custom_format"}, to be supplied
to the \code{custom_format} argument of \code{tar_resources()}.
}
\description{
Create the \code{custom_format} argument of \code{tar_resources()}
to specify optional target settings for custom storage formats.
}
\details{
\code{tar_resources_custom_format()} accepts
target-specific settings to customize \code{\link[=tar_format]{tar_format()}} storage formats.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name = target_name,
  command = data.frame(x = 1),
  format = tar_format(
    read = function(path) {
      readRDS(file = path)
    },
    write = function(object, path) {
      version <- as.integer(Sys.getenv("SERIALIZATION", unset = "2"))
      saveRDS(object = object, file = path, version = version)
    }
  ),
  resources = tar_resources(
    custom_format = tar_resources_custom_format(
      envvars = c(SERIALIZATION = "3")
    )
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources}()},
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_network}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_repository_cas}()},
\code{\link{tar_resources_url}()}
}
\concept{resources}
