% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pie_bake_pro.R
\name{pie_bake_pro}
\alias{pie_bake_pro}
\title{Easily create (more complex) pie charts}
\usage{
pie_bake_pro(data, template, group_name = "group", title = "")
}
\arguments{
\item{data}{A data frame (or a tibble) with two variables (columns):\cr
\itemize{
\item in the first one there must be the vector of labels;\cr
\item in the second one there must be the vector of values.
}

Please note that the labels are automatically sorted in alphabetical order.
If you want to specify a particular order, it is recommended to type numbers or
letters before the category names (e.g. "a. category1", "b. category2", ...).\cr
You can use \code{\link{pie_datacheck}} to understand if the data is suitable.}

\item{template}{The chosen template.\cr
Type \code{pie_template_list_pro} to display all the available ones for this function.}

\item{group_name}{A string. If you want, you can specify a name for the categories.}

\item{title}{A string. If you want, you can specify the title of the graph.}
}
\value{
A ggplot object (or no value if the chosen template is among the spider chart ones).
In particular, this function returns a pie (or similar) chart according to the
data, the choice of template, and the other specifications provided.
}
\description{
This function allows you to create cool pie charts easily by providing just
the data and a template among the available ones. Moreover, you can optionally
specify a title for the chart and a name for the categories.\cr \cr
Using this function you can create some \emph{complex and extravagant} pie charts.
If you are looking for something more \emph{classical} (and probably more understandable),
check out the \code{\link{pie_bake}} function.
}
\examples{
example <- data.frame(
  c("a. This", "b. Is", "c. Just", "d. An", "e. Example"),
  c(2.9, 6.9, 4.20, 13.12, 6.66)
)
pie_bake_pro(
  data = example,
  template = "eaten3",
  group_name = "cat:",
  title = "Example1"
)

pie_bake_pro(
  data = example,
  template = "dart1",
  title = "Example2!"
)

pie_bake_pro(
  data = example,
  template = "eye5",
  group_name = "GROUPS:"
)

pie_bake_pro(
  data = example,
  template = "spider2"
  )


}
\seealso{
See all the available templates displayed
\href{https://paolodalena.github.io/tastypie/articles/available_templates.html}{here}!
}
