% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_strings.R
\name{clean_strings}
\alias{clean_strings}
\alias{clean_strings,character-method}
\alias{clean_strings,factor-method}
\alias{clean_strings,data.frame-method}
\title{Cleaning character strings.}
\usage{
clean_strings(x, ...)

\S4method{clean_strings}{character}(x, from = "utf8", to = "utf8", ...)

\S4method{clean_strings}{factor}(x, from = "utf8", to = "utf8", ...)

\S4method{clean_strings}{data.frame}(x, from = "utf8", to = "utf8", ...)
}
\arguments{
\item{x}{Object to be cleaned.}

\item{...}{Further arguments passed among methods (not yet in use).}

\item{from, to}{Arguments passed to \code{\link[=iconv]{iconv()}}.}
}
\value{
The same as input \code{x}.
}
\description{
Multiple, leading and trailing white spaces as well as wrong encodings may
cause serious problems in information dealing with taxonomic names.
The function \code{clean_strings} get rid of them.
}
\details{
This function automatically deletes leading, trailing and multiple white
spaces, either in strings (method \code{character}), levels (method
\code{factor} or in single columns (method \code{data.frame}).
}
\examples{
## Leading, trailing and multiple spaces
clean_strings(" Cyperus    papyrus L.     ")
}
\author{
Miguel Alvarez.
}
