% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_binom.R
\name{tbr_binom}
\alias{tbr_binom}
\title{Time-Based Rolling Binomial Probability}
\usage{
tbr_binom(.tbl, x, tcolumn, unit = "years", n, alpha = 0.05, na.pad = TRUE)
}
\arguments{
\item{.tbl}{dataframe with two variables.}

\item{x}{indicates the variable column containing "success" and "failure"
observations coded as 1 or 0.}

\item{tcolumn}{indicates the variable column containing Date or Date-Time
values.}

\item{unit}{character, one of "years", "months", "weeks", "days", "hours",
"minutes", "seconds"}

\item{n}{numeric, describing the length of the time window in the selected
units.}

\item{alpha}{numeric, probability of a type 1 error, so confidence
coefficient = 1-alpha}

\item{na.pad}{logical. If `na.pad = TRUE` incomplete windows (duration of the window < `n`) return `NA`. Defatuls to `TRUE`}
}
\value{
tibble with binomial point estimate and confidence intervals.
}
\description{
Produces a a rolling time-window based vector of binomial probability and
confidence intervals.
}
\examples{
## Generate Sample Data
df <- tibble::tibble(
date = sample(seq(as.Date('2000-01-01'), as.Date('2015/12/30'), by = "day"), 100),
value = rbinom(100, 1, 0.25)
)

## Run Function
tbr_binom(df, x = value,
tcolumn = date, unit = "years", n = 5,
alpha = 0.1, na.pad = FALSE)
}
\seealso{
\code{\link{binom_ci}}
}
