#' Biological data
#'
#' A list of biological data: RNASeq data, phenotypic
#' metadata and cell abundance.
#'
#' \itemize{
#'   \item \code{genes}: RNASeq from The Cancer Genome Atlas (TCGA) database.
#'   \item \code{phenotypes}: Metadata from the TCGA database containing
#' sample ID, sample type ID, sample type and primary disease.
#'   \item \code{cells}: Abundance estimates of cell types
#' }
#' @note
#' Subset of thirty samples of invasive breast carcinoma data from primary
#' tumor tissue. The cell type data are from a subset generated by the
#' Cibersort_ABS algorithm (\url{https://cibersortx.stanford.edu}).
#' For the complete dataset, please use:
#' \cr\cr
#' \code{path <- system.file("extdata", package = "tcgaViz")}
#' \cr
#' \code{load(file.path(path, "tcga.rda"))}
#' @source
#' - dataset: gene expression RNAseq - Batch effects normalized mRNA data
#' - hub: \url{https://pancanatlas.xenahubs.net}
#' - cohort: TCGA Pan-Cancer (PANCAN)
#' - dataset ID: EB++AdjustPANCAN_IlluminaHiSeq_RNASeqV2.geneExp.xena
#' - download: \url{https://tcga-pancan-atlas-hub.s3.us-east-1.amazonaws.com/download/EB%2B%2BAdjustPANCAN_IlluminaHiSeq_RNASeqV2.geneExp.xena.gz} (full metadata)
#' - samples: 11060
#' - version: 2016-12-29
#' - type of data: gene expression RNAseq
#' - unit: log2(norm_value+1)
#' - raw data: \url{https://www.synapse.org/#!Synapse:syn4976369.3}
#' - input data format: ROWs (identifiers) x COLUMNs (samples) (i.e. genomicMatrix)
#' @examples
#' data(tcga)
#' (df <- convert2biodata(
#'     algorithm = "Cibersort_ABS",
#'     disease = "breast invasive carcinoma",
#'     tissue = "Primary Tumor",
#'     gene_x = "ICOS"
#' ))
#' (stats <- calculate_pvalue(df))
#' \donttest{
#' plot(df, stats = stats)
#' }
#' @docType data
#' @keywords datasets
#' @name tcga
#' @usage data(tcga)
NULL
