% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2biodata.R
\name{convert2biodata}
\alias{convert2biodata}
\title{Format biological data}
\usage{
convert2biodata(algorithm, disease, tissue, gene_x, stat = "mean", path = ".")
}
\arguments{
\item{algorithm}{character for the algorithm used to estimate the
distribution of cell type abundance among : 'Cibersort', 'Cibersort_ABS',
'EPIC', 'MCP_counter', 'Quantiseq', 'Timer', 'Xcell', 'Xcell (2)' and
'Xcell64'.}

\item{disease}{character for the type of TCGA cancer (see the list in
extdata/disease_names.csv).}

\item{tissue}{character for the type of TCGA tissue among :
'Additional - New Primary',
'Additional Metastatic',
'Metastatic',
'Primary Blood Derived Cancer - Peripheral Blood',
'Primary Tumor',
'Recurrent Tumor',
'Solid Tissue Normal'}

\item{gene_x}{character for the gene selected in the differential analysis
(see the list in extdata/gene_names.csv).}

\item{stat}{character for the statistic to be chosen among "mean", "median"
or "quantile".}

\item{path}{character for the path name of the \code{tcga} dataset.}
}
\value{
data frame with the following columns:
\itemize{
\item \code{high} (logical): the expression levels of a selected gene,
TRUE for below or FALSE for above average.
\item \code{cells} (factor): cell types.
\item \code{value} (float): the abundance estimation of the cell types.
}
}
\description{
Merges gene and cell datasets with the same TCGA sample identifiers,
splits samples according to the expression levels of a selected gene into
two categories (below or above average) and formats into a 3-column
data frame: gene expression levels, cell types, and gene expression values.
}
\examples{
data(tcga)
(convert2biodata(
    algorithm = "Cibersort_ABS",
    disease = "breast invasive carcinoma",
    tissue = "Primary Tumor",
    gene_x = "ICOS"
))
}
