% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_kim}
\alias{pkmod_kim}
\title{Kim population PK model for remifentanil}
\usage{
pkmod_kim(AGE, TBW, HGT = NULL, BMI = NULL, MALE = NULL, FFM = NULL, ...)
}
\arguments{
\item{AGE}{Age (years)}

\item{TBW}{Total body weight (kg).}

\item{HGT}{Height (cm). Used to calculate BMI if BMI is not provided.}

\item{BMI}{Body mass index. Used to calculate LBM if LBM is not provided.}

\item{MALE}{Logical. Used to calculate LBM if LBM is not provided.}

\item{FFM}{Fat-free mass. Can be used instead of BMI and MALE.}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Schnider population PK parameters
}
\description{
Evaluate Kim population PK model at patient covariate values.
Published in Kim et al. (2017). "Disposition of Remifentanil in Obesity: A New
Pharmacokinetic Model Incorporating the Influence of Body Mass"
Anesthesiology Vol. 126, 1019–1032. doi: https://doi.org/10.1097/ALN.0000000000001635
}
\examples{
pkmod_kim(AGE = 40,TBW = 75, BMI = 30, MALE = TRUE)
pkmod_kim(AGE = 40,TBW = 75, FFM = 52.83)
}
