% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplMakeChidMultiPlts.R
\name{tcplMakeChidMultiPlts}
\alias{tcplMakeChidMultiPlts}
\title{Create a .pdf with all dose-response plots for a given chid, 6 per page}
\usage{
tcplMakeChidMultiPlts(
  chid,
  lvl = 4L,
  fname = NULL,
  odir = getwd(),
  hitc.all = TRUE
)
}
\arguments{
\item{chid}{Integer of length 1, the chemical id}

\item{lvl}{Integer of length 1, the data level to use (4-7)}

\item{fname}{Character, the filename}

\item{odir}{The directory to save the .pdf file in}

\item{hitc.all}{If FALSE, only plots with hitc==1 will be displayed}
}
\description{
\code{tcplMakeChidMultiPlts} Create a .pdf with all dose-response plots for a given chid
}
\details{
\code{tcplMakeChidMultiPlts} provides a wrapper for \code{\link{tcplMultiplot}},
allowing the user to produce PDFs with the curve plots without having to 
separately load all of the data and establish the PDF device.

If 'fname' is \code{NULL}, a default name is given by concatenating together
assay information.
}
