% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arm_ref_comp.R
\name{arm_ref_comp_observer}
\alias{arm_ref_comp_observer}
\title{Observer for Treatment reference variable}
\usage{
arm_ref_comp_observer(
  session,
  input,
  output,
  id_ref = "Ref",
  id_comp = "Comp",
  id_arm_var,
  data,
  arm_ref_comp,
  module,
  on_off = reactive(TRUE),
  input_id = "buckets",
  output_id = "arms_buckets"
)
}
\arguments{
\item{session}{(\code{environment})\cr shiny session}

\item{input}{(\code{character})\cr shiny input}

\item{output}{(\code{character})\cr shiny input}

\item{id_ref}{(\code{character})\cr id of reference Treatment input UI element}

\item{id_comp}{(\code{character})\cr id of comparison group input UI element}

\item{id_arm_var}{(\code{character})\cr id of Treatment variable input UI element}

\item{data}{(\code{reactive} or \code{data.frame})\cr dataset used to validate Treatment reference inputs and
set \code{id_ref} input.}

\item{arm_ref_comp}{(\code{unknown})\cr Treatment reference and compare variables provided as a
nested list where each Treatment variable corresponds a list specifying the default levels for the
reference and comparison treatments.}

\item{module}{(\code{character})\cr name of the module where this is called (this is only used
to produce more informative error messages)}

\item{on_off}{(\code{logical})\cr A reactive that can be used to
stop the whole observer if \code{FALSE}.}

\item{input_id}{(\code{character})\cr unique id that the buckets will be referenced with.}

\item{output_id}{(\code{character})\cr name of the UI id that the output will be written to.}
}
\value{
Returns a \code{shinyvalidate::InputValidator} which checks that there is at least one reference
and comparison arm
}
\description{
Updates the reference and comparison Treatments when the selected Treatment variable changes
}
\keyword{internal}
