#' Concatenate `teal_report` objects
#'
#' @param ... (`teal_report`) objects to concatenate
#'
#' @return A [`teal_report`] object with combined [`teal_card`] elements.
#'
#' @export
#' @method c teal_report
c.teal_report <- function(...) {
  result <- NextMethod()
  l <- Filter(function(x) inherits(x, "teal_report"), list(...))
  if (length(l) > 1) {
    teal_card(result) <- suppressWarnings(do.call(c, lapply(l, teal_card)), classes = "teal_card_append")
  }
  result
}
