% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_retrieve.R
\name{retrieve_sensor}
\alias{retrieve_sensor}
\title{Retrieves data associated with a sensor from the Telraam API}
\usage{
retrieve_sensor(segment_name, start_date, end_date, key = get_telraam_token())
}
\arguments{
\item{segment_name}{Character. Name of the segment, as specified in config.}

\item{start_date}{Date. Start date "aaaa-mm-jj", must be of the date type.}

\item{end_date}{Date. End date "aaaa-mm-jj", must be of the date type.}

\item{key}{the API key (set by the \code{set_telraam_token()} function)}
}
\value{
Dataframe from Telraam API, enriched with \code{enrich_traffic()} function.
}
\description{
Retrieves data associated with a sensor from the Telraam API.
The data is retrieved for a specified time period between \code{start_date} and \code{end_date} (inclusive).
}
\examples{
\dontrun{ # This function requires a valid API key
period <- as.Date(c('2022-01-01', '2022-12-31'))
retrieve_sensor('RteVitre-06', period[1], period[2])
}

}
