% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter-excel.R
\name{output_results_excel}
\alias{output_results_excel}
\title{Output \code{ListReporter} results in Excel format}
\usage{
output_results_excel(results, file)
}
\arguments{
\item{results}{An object of class \code{testthat_results}, e.g. output from
\code{\link[testthat:test_dir]{testthat::test_dir()}} or \code{\link[testthat:test_file]{testthat::test_file()}}.}

\item{file}{Output file name}
}
\value{
The return value of \code{\link[openxlsx:saveWorkbook]{openxlsx::saveWorkbook()}}.
}
\description{
Output formatted \code{ListReporter} results to an Excel workbook using
\link[openxlsx:openxlsx]{openxlsx}. The workbook consists of a summary sheet
showing aggregated results for each context, and one sheet per context
showing details of each unsuccessful test.
}
\examples{
\dontrun{
# Output the results from running all tests in a directory
x <- test_dir(".")
output_results_excel(x, "Test results.xlsx")
}
}
