% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{rm_words}
\alias{rm_words}
\title{Remove rows from a text.table with specific words}
\usage{
rm_words(x, text, words = stopwords)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x to check for words to delete.}

\item{words}{A vector of words to delete from x.}
}
\value{
A text.table, with rows deleted if the words in those rows are in the vector of words to delete.
}
\description{
Remove rows from a text.table with specific words
}
\examples{
rm_words(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2"
)
}
