% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebase.R
\name{tf_rebase}
\alias{tf_rebase}
\alias{tf_rebase.tfd}
\alias{tf_rebase.tfb}
\title{Change (basis) representation of a \code{tf}-object}
\usage{
tf_rebase(object, basis_from, arg = tf_arg(basis_from), ...)

\method{tf_rebase}{tfd}(object, basis_from, arg = tf_arg(basis_from), ...)

\method{tf_rebase}{tfb}(object, basis_from, arg = tf_arg(basis_from), ...)
}
\arguments{
\item{object}{a \code{tf} object whose representation should be changed}

\item{basis_from}{the \code{tf} object with the desired basis, \code{arg}, \code{evaluator}, etc.}

\item{arg}{optional new \code{arg} values, defaults to those of \code{basis_from}}

\item{...}{forwarded to the \code{tfb} or \code{tfd} constructors}
}
\value{
a \code{tf}-vector containing the data of \code{object} in the same representation
as \code{basis_from} (potentially modified by the arguments given in \code{...}).
}
\description{
Apply the representation of one \code{tf}-object to another; i.e. re-express it in
the other's basis, on its grid, etc.\cr
Useful for making different functional data objects compatible so they can
be combined, compared or computed with.
}
\details{
This uses double dispatch (S3) internally, so the methods defined below are
themselves generics for methods \code{tf_rebase.tfd.tfd},
\code{tf_rebase.tfd.tfb_spline}, \code{tf_rebase.tfd.tfb_fpc}, \code{tf_rebase.tfb.tfd},
\code{tf_rebase.tfb.tfb} that dispatch on \code{object_from}.
}
\section{Methods (by class)}{
\itemize{
\item \code{tf_rebase(tfd)}: re-express a \code{tfd}-vector in the same representation as
some other  \code{tf}-vector

\item \code{tf_rebase(tfb)}: re-express a \code{tfb}-vector in the same representation as
some other  \code{tf}-vector.

}}
