% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_generate_subcortical_surf.R
\name{generate_subcortical_surface}
\alias{generate_subcortical_surface}
\title{Approximate 'sub-cortical' surfaces from 'parcellation'}
\usage{
generate_subcortical_surface(
  atlas,
  index,
  save_prefix = NULL,
  label = NULL,
  IJK2RAS = NULL,
  grow = 1,
  remesh = TRUE,
  smooth = TRUE,
  smooth_delta = 3,
  ...
)
}
\arguments{
\item{atlas}{path to imaging 'parcellation', can be \code{'nii'} or \code{'mgz'} formats}

\item{index}{'parcellation' index, see 'FreeSurfer' look-up table}

\item{save_prefix}{parent folder to save the resulting surface}

\item{label}{character label or name of the 'sub-cortical' structure, usually automatically derived from \code{index}}

\item{IJK2RAS}{an 'Affine' matrix from 'voxel' index to \code{'tkrRAS'}, usually automatically derived from \code{atlas}}

\item{grow}{amount to grow (dilate) before generating mesh}

\item{remesh, smooth, smooth_delta, ...}{passed to \code{\link[ravetools]{mesh_from_volume}}}
}
\value{
A surface mesh, containing 'atlas' index, label, surface nodes and face indices.
}
\description{
Superseded by \code{\link{volume_to_surf}}. Please do not use this function.
}
