% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluck-model.R
\name{get_model}
\alias{get_model}
\title{Get a Model}
\usage{
get_model(.data, .model_id = NULL)
}
\arguments{
\item{.data}{The model table that must have the class \code{tidyaml_mod_spec_tbl}.}

\item{.model_id}{The model number that you want to select, Must be an integer
or sequence of integers, ie. \code{1} or \code{c(1,3,5)} or \code{1:2}}
}
\value{
A tibble with the chosen models.
}
\description{
Get a model from a tidyAML model tibble.
}
\details{
This function allows you to get a model or models from a tibble with
a class of "tidyaml_mod_spec_tbl". It allows you to select the model by the
\code{.model_id} column. You can call the model id's by an integer or a sequence
of integers.
}
\examples{
library(recipes)

rec_obj <- recipe(mpg ~ ., data = mtcars)
spec_tbl <- fast_regression_parsnip_spec_tbl(
  .parsnip_fns = "linear_reg",
  .parsnip_eng = c("lm","glm")
)

get_model(spec_tbl, 1)
get_model(spec_tbl, 1:2)

}
\seealso{
Other Extractor: 
\code{\link{extract_model_spec}()},
\code{\link{extract_regression_residuals}()},
\code{\link{extract_tunable_params}()},
\code{\link{extract_wflw}()},
\code{\link{extract_wflw_fit}()},
\code{\link{extract_wflw_pred}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Extractor}
