% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{bde_ind_db}
\alias{bde_ind_db}
\title{Database of selected macroeconomic indicators}
\format{
A \link[tibble:tbl_df-class]{tibble} of 9 rows and
7 columns with the following fields:

\describe{
\item{tidyBdE_fun}{Function name, see \link{bde_indicators}.}
\item{Numero_secuencial}{Series code, see \code{\link[=bde_series_load]{bde_series_load()}}.}
\item{Descripcion_de_la_serie}{Description of the series in Spanish.}
\item{Fecha_de_la_primera_observacion}{Starting date of the indicator.}
\item{Fecha_de_la_ultima_observacion}{Most recent date available.}
\item{Fuente}{Data source.}
}
}
\description{
Minimal metadata of the selected macroeconomic indicators included in helper
functions of \CRANpkg{tidyBdE} (see \link{bde_indicators}). Full metadata can be
accessed via \code{\link[=bde_catalog_load]{bde_catalog_load()}}
}
\details{
\tabular{lllllll}{
   \strong{tidyBdE_fun} \tab \strong{Numero_secuencial} \tab \strong{Descripcion_de_la_serie} \tab \strong{Frecuencia_de_la_serie} \tab \strong{Fecha_de_la_primera_observacion} \tab \strong{Fecha_de_la_ultima_observacion} \tab \strong{Fuente} \cr
   bde_ind_cpi_var \tab 4144807 \tab Índice de Precios de Consumo (IPC). Año Base 2021. Índice General. Total Nacional. Tasa de variación interanual \tab MENSUAL \tab 1962-01-01 \tab 2025-03-01 \tab INSTITUTO NACIONAL DE ESTADISTICA \cr
   bde_ind_euribor_12m_daily \tab 905842 \tab Interest rate. EMU. Money market. Euribor. 12 months \tab LABORABLE \tab 2000-01-03 \tab 2025-04-15 \tab REFINITIV \cr
   bde_ind_euribor_12m_monthly \tab 587853 \tab Tipo de interés. UEM. Mercado monetario. Euríbor. A 12 meses \tab MENSUAL \tab 1999-01-01 \tab 2025-03-01 \tab The European Money Market Institute (EMMI) \cr
   bde_ind_gdp_quarterly \tab 4663160 \tab Estadísticas Generales. Cuentas Nacionales. SEC2010. Año base 2020. Precios corrientes. Producto interior bruto. Economía en su conjunto (Total de la economía) (Saldo). Datos corregidos de efectos estacionales y de calendario. TRIMESTRAL \tab TRIMESTRAL \tab 1995-03-01 \tab 2024-12-01 \tab Instituto Nacional de Estadistica \cr
   bde_ind_gdp_var \tab 4663788 \tab Estadísticas Generales. Cuentas Nacionales. SEC2010. Año base 2020. Índices de volumen encadenados. Producto interior bruto. Economía en su conjunto (Total de la economía) (Saldo). Datos corregidos de efectos estacionales y de calendario, Tasa de variación interanual. TRIMESTRAL \tab TRIMESTRAL \tab 1996-03-01 \tab 2024-12-01 \tab Instituto Nacional de Estadistica \cr
   bde_ind_ibex_daily \tab 821340 \tab Cotización y contratación. Acciones. Sociedad de Bolsas y Sociedad Rectora de la Bolsa de Madrid. Índice cotización. Indice IBEX 35 \tab LABORABLE \tab 1999-01-04 \tab 2025-04-15 \tab Bolsa de Madrid y Comisión Nacional del Mercado de Valores \cr
   bde_ind_ibex_monthly \tab 254433 \tab Cotización y contratación. Acciones. Sociedad de Bolsas y Sociedad Rectora de la Bolsa de Madrid. Índice cotización. Indice IBEX 35 \tab MENSUAL \tab 1987-01-01 \tab 2025-02-01 \tab SOCIEDAD RECTORA DE LA BOLSA DE MADRID \cr
   bde_ind_population \tab 4637737 \tab Estadísticas generales. INE. EPA. Base 2021. Total Nacional. Ambos sexos. Todas las edades. Personas. Trimestral \tab TRIMESTRAL \tab 2002-03-01 \tab 2024-12-01 \tab Instituto Nacional de Estadística \cr
   bde_ind_unemployment_rate \tab 4635980 \tab Estadísticas generales. INE. EPA. Base 2021. Total Nacional. Tasa de paro de la población. Ambos sexos. 16 y más años. Trimestral \tab TRIMESTRAL \tab 2002-03-01 \tab 2024-12-01 \tab Instituto Nacional de Estadística \cr
}
}
\examples{
data("bde_ind_db")
bde_ind_db

}
\seealso{
Other indicators: 
\code{\link{bde_indicators}}
}
\concept{indicators}
