% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyDenovix.R
\name{tidyDenovix}
\alias{tidyDenovix}
\title{Title: Clean data from the Denovix DS-11 instrument}
\usage{
tidyDenovix(
  dfile,
  file_type = NULL,
  sample_type = c("RNA", "DNA"),
  check_level = c("strict", "lax"),
  qc_omit = NULL,
  normalized = c("yes", "no"),
  fun = NA
)
}
\arguments{
\item{dfile}{The raw file obtained from the machine.}

\item{file_type}{The file type specification.}

\item{sample_type}{The sample type specification used in quality control.}

\item{check_level}{The level of quality control performed.}

\item{qc_omit}{Takes 'yes' or 'no' and determines if the qc data would be provided.}

\item{normalized}{Takes 'yes' or 'no'.}

\item{fun}{A parameter used for boolean expressions.}
}
\value{
A cleaned data frame with attribute names in some instances.
}
\description{
Title: Clean data from the Denovix DS-11 instrument
}
\note{
The strict level of QC yields a data frame with no attribute names.
This will be worked on so that users get the sample names for their data.
}
\examples{
fpath <- system.file("extdata", "rnaspec2018.csv", package = "tidyDenovix", mustWork = TRUE)
rna_data = tidyDenovix(fpath, file_type = 'csv', sample_type = 'RNA', check_level = 'lax')
}
\author{
Tingwei Adeck
}
