% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demultiplex.R
\name{demultiplex}
\alias{demultiplex}
\title{Demultiplex reads by locus}
\usage{
demultiplex(
  interpreter = "/bin/bash",
  cutadapt = system2("which", "cutadapt", stdout = TRUE),
  freads,
  rreads = NULL,
  primers = NULL,
  sh_out = tempfile(fileext = ".sh"),
  outdir = tempdir(),
  log_out = tempfile(fileext = ".log"),
  temp_folder = tempdir(),
  mode = "pe",
  overlap = 15,
  e = 0.15,
  extraArgs = "",
  run = TRUE
)
}
\arguments{
\item{interpreter}{Path to interpreter.}

\item{cutadapt}{Path to cutadapt executable.}

\item{freads}{Character vector with file paths to forward reads.}

\item{rreads}{Character vector with file paths to reverse reads.}

\item{primers}{Dataframe with primers}

\item{sh_out}{File name for cutadapt command.}

\item{outdir}{Directory to write demultiplexed FASTQ files.
Created if it does not exist.}

\item{log_out}{Path to write cutadapt log file.}

\item{temp_folder}{Directory to save temp files.}

\item{mode}{"pe", paired-end; "se", single-end; or "linked" (beta, non-tested),
for linked primers.}

\item{overlap}{--overlap (see cutadapt documentation).}

\item{e}{-e (see cutadapt documentation).}

\item{extraArgs}{Other arguments for cutadapt (eg "--max-n 0
--max-expected-errors 3 --minimum-length=20").}

\item{run}{T/F, whether to run the script (T) or just write it (F).}
}
\value{
Demultiplexed 'sample.locus.[12].fastq.gz'.
}
\description{
Sequencing reads are demultiplexed by locus into separate FASTQ files
(locus.sample.[1|2].fastq.gz) based on the locus-specific primer
sequences using \code{cutadapt}.
}
\details{
This function creates a bash script to run cutadapt. By turning on running 'run = T',
the function will try to execute the bash script produced (written to 'sh_out'). If the function produces any errors
it is recommended to turn off running 'run = FALSE' and inspect the bash script produced to detect
mis-specified cutadapt arguments or erroneous paths, and to solve them using the cutadapt documentation.
}
\examples{
data("primers")
freads <-
 list.files(system.file("extdata", "raw",
                        package = "tidyGenR"),
                        pattern = "1.fastq.gz",
            full.names = TRUE)
rreads <-
 list.files(system.file("extdata", "raw",
                        package = "tidyGenR"),
                        pattern = "2.fastq.gz",
            full.names = TRUE)
demultiplex(
    freads = freads,
    rreads = rreads,
    primers = primers,
    run = FALSE)

}
