% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_correlation.R
\name{summarise_correlation}
\alias{summarise_correlation}
\title{Summarise Correlation Matrix with Optional Significance Tests}
\usage{
summarise_correlation(
  x,
  y = NULL,
  method = c("pearson", "kendall", "spearman"),
  cor_test = FALSE
)
}
\arguments{
\item{x}{A numeric vector, matrix, data frame, or tibble.}

\item{y}{Optional. A second numeric vector, matrix, or data frame (same dimensions as `x`).}

\item{method}{Character. One of "pearson" (default), "kendall", or "spearman".}

\item{cor_test}{Logical. If TRUE, uses `cor.test()` and includes p-values. If FALSE, uses `cor()` only.}
}
\value{
A tibble with variables, correlations, and optionally p-values.
Significant results (p < 0.05) are printed in red in the console.
}
\description{
Computes correlations between numeric variables of a data frame, or between two vectors. 
Optionally tests statistical significance (p-value)
}
\examples{
summarise_correlation(iris)
summarise_correlation(iris$Sepal.Length, iris$Petal.Length, cor_test = TRUE)

}
