% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_skewness.R
\name{summarise_skewness}
\alias{summarise_skewness}
\title{Summarise Skewness}
\usage{
summarise_skewness(x)
}
\arguments{
\item{x}{A numeric vector, matrix, data frame, or tibble.}
}
\value{
A tibble:
- If input has one numeric column or is a numeric vector: a tibble with a single value.
- If input has multiple numeric columns: a tibble with variable names and skewness values.
}
\description{
Calculates skewness for numeric vectors, matrices, data frames, or tibbles using Pearson’s moment coefficient.
}
\examples{
summarise_skewness(iris)
summarise_skewness(as.vector(iris$Sepal.Width))
summarise_skewness(data.frame(a = rnorm(100), b = rgamma(100, 2)))
}
