% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regress}
\alias{regress}
\title{Compute linear regression}
\usage{
regress(
  data,
  dependent_var,
  ...,
  check_independenterrors = FALSE,
  check_multicollinearity = FALSE,
  check_homoscedasticity = FALSE
)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model}

\item{dependent_var}{The dependent variable on which the linear model is
fitted. Specify as column name.}

\item{...}{Independent variables to take into account as (one or many)
predictors for the dependent variable. Specify as column names. At least
one has to be specified.}

\item{check_independenterrors}{if set, the independence of errors among any
two cases is being checked using a Durbin-Watson test}

\item{check_multicollinearity}{if set, multicollinearity among all specified
independent variables is being checked using the variance inflation factor
(VIF) and the tolerance (1/VIF); this check can only be performed if at
least two independent variables are provided, and all provided variables
need to be numeric}

\item{check_homoscedasticity}{if set, homoscedasticity is being checked
using a Breusch-Pagan test}
}
\value{
a \link{tdcmm} model
}
\description{
Computes linear regression for all independent variables on the specified
dependent variable. Linear modeling of multiple independent variables uses
stepwise regression modeling. If specified, preconditions for
(multi-)collinearity and for homoscedasticity are checked.
}
\examples{
WoJ \%>\% regress(autonomy_selection, ethics_1)
WoJ \%>\% regress(autonomy_selection, work_experience, trust_government)

}
