% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-scaling.R
\name{rescale}
\alias{rescale}
\alias{rescale.numeric}
\alias{rescale.dist}
\alias{rescale.logical}
\alias{rescale.POSIXt}
\alias{rescale.Date}
\alias{rescale.integer64}
\title{Rescale continuous vector to have specified minimum and maximum}
\usage{
rescale(x, to, from, ...)

\method{rescale}{numeric}(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE), ...)

\method{rescale}{dist}(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE), ...)

\method{rescale}{logical}(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE), ...)

\method{rescale}{POSIXt}(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE), ...)

\method{rescale}{Date}(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE), ...)

\method{rescale}{integer64}(x, to = c(0, 1), from = range(x, na.rm = TRUE), ...)
}
\arguments{
\item{x}{continuous vector of values to manipulate.}

\item{to}{output range (numeric vector of length two)}

\item{from}{input range (vector of length two).  If not given, is
calculated from the range of \code{x}}

\item{...}{other arguments passed on to methods}
}
\description{
Rescale continuous vector to have specified minimum and maximum
}
\keyword{internal}
