% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference.R
\name{get_difference}
\alias{get_difference}
\title{Get difference between two smooths}
\usage{
get_difference(
  model,
  series,
  compare,
  values = NULL,
  exclude_terms = NULL,
  length_out = 25,
  ci_z = 1.96
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{series}{A string specifying the variable that corresponds to the series
to be plotted on the $x$-axis. If a string is given, the other numeric
variables in the model are set to their mean value, unless specific values
are given in \code{values}. If a character vector of two strings is given, the
two variables will be taken as the elements of a tensor product smooth.
This allows the user to plot 2D raster plots.}

\item{compare}{A named list of factor levels to compare.}

\item{values}{User supplied values for specific variables as a named list.}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names
should be given as they appear in the model summary (for example,
\code{"s(x0,x1)"}).}

\item{length_out}{An integer indicating how many values to use along the
numeric variables for predicting the response (the default is \code{10}).}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for
95 percent CI).}
}
\value{
A tibble with the difference smooth.
}
\description{
Get difference between two smooths
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ s(x2, by = fac) + s(x0), data = data)

get_difference(model, "x2", list(fac = c("1", "2")))
}
