% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gethklips.R
\name{gethklips}
\alias{gethklips}
\title{`gethklips()' is used to obtain data.frame for KLIPS (head of household survey)}
\usage{
gethklips(
  path,
  year,
  datatype = c("stata", "spss", "sas", "xlsx"),
  klipsvars = c("0141", "2102"),
  outvars = c("province", "income")
)
}
\arguments{
\item{path}{A string vector specifying folder containing KLIPS head of household survey data}

\item{year}{an integer vector  specifying the years from 1998 to 2023 that the user wants to include in the dataframe.}

\item{datatype}{A string vector specifying the format of the raw data you want to convert to a data frame ("spss", "sas", "stata", "excel")}

\item{klipsvars}{A string vector specifying the variables in the raw data that you want to convert to a data frame ("0141", "2102")}

\item{outvars}{A string vector specifying the variable names of converted data ("province", "income")}
}
\value{
A data frame containing klips household member data with the specified years and variables.
\itemize{
\item \code{gethklips()} returns an integer dataframe with two and more columns and
rows for each head of household. The first column, \code{hhid},
refers to the respondent id number, and the last column, \code{year},
refers to the year that the user wants to include in the dataframe.
}
}
\description{
`gethklips()' is used to obtain data.frame for KLIPS (head of household survey)
}
\examples{

path <- system.file("extdata", package = "tidyklips")
df <- gethklips(path = path, year = 2023, datatype = "stata")
df \%>\%
  dplyr::group_by(year) \%>\%
  dplyr::summarise(count = dplyr::n()) \%>\%
  dplyr::mutate(proportion = count / sum(count))


}
