% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getwklips.R
\name{getwklips}
\alias{getwklips}
\title{`getwklips()' is used to obtain data.frame for KLIPS (career data)}
\usage{
getwklips(
  path,
  datatype = c("stata", "spss", "sas", "xlsx"),
  klipsvars = c("jobseq", "jobtype"),
  outvars = c("jobseq", "jobtype")
)
}
\arguments{
\item{path}{A string vector specifying folder containing KLIPS career data}

\item{datatype}{A string vector specifying the format of the raw data you want to convert to a data frame ("spss", "sas", "stata", "excel")}

\item{klipsvars}{A string vector specifying the variables in the raw data that you want to convert to a data frame ("jobseq", "jobtype")}

\item{outvars}{A string vector specifying the variable names of converted data ("jobseq", "jobtype")}
}
\value{
A data frame containing klips household member data with the specified years and variables.
\itemize{
\item \code{getwklips()} returns an integer dataframe with two and more columns and
rows for each respondent. The first column, \code{pid},
refers to the respondent id number, and the last column, \code{year},
refers to the year that the user wants to include in the dataframe.
}
}
\description{
`getwklips()' is used to obtain data.frame for KLIPS (career data)
}
\examples{

path <- system.file("extdata", package = "tidyklips")
df <- getwklips(path = path, datatype = "stata")
df \%>\%
  dplyr::group_by(jobseq) \%>\%
  dplyr::summarise(count = dplyr::n()) \%>\%
  dplyr::mutate(proportion = count / sum(count))


}
