% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-svm.R
\name{tl_fit_svm}
\alias{tl_fit_svm}
\title{Fit a support vector machine model}
\usage{
tl_fit_svm(
  data,
  formula,
  is_classification = FALSE,
  kernel = "radial",
  cost = 1,
  gamma = NULL,
  degree = 3,
  tune = FALSE,
  tune_folds = 5,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{kernel}{Kernel function ("linear", "polynomial", "radial", "sigmoid")}

\item{cost}{Cost parameter (default: 1)}

\item{gamma}{Gamma parameter for kernels (default: 1/ncol(data))}

\item{degree}{Degree for polynomial kernel (default: 3)}

\item{tune}{Logical indicating whether to tune hyperparameters (default: FALSE)}

\item{tune_folds}{Number of folds for cross-validation during tuning (default: 5)}

\item{...}{Additional arguments to pass to svm()}
}
\value{
A fitted SVM model
}
\description{
Fit a support vector machine model
}
\keyword{internal}
