% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rulelist.R
\name{as_rulelist.data.frame}
\alias{as_rulelist.data.frame}
\title{as_rulelist method for a data.frame}
\usage{
\method{as_rulelist}{data.frame}(x, keys = NULL, model_type = NULL, estimation_type, ...)
}
\arguments{
\item{x}{dataframe to be coerced to a \link{rulelist}}

\item{keys}{(character vector, default: NULL) column names which form the key}

\item{model_type}{(string, default: NULL) Name of the model which generated
the rules}

\item{estimation_type}{(string) One among: 'regression',
'classification'}

\item{...}{currently unused}
}
\value{
\link{rulelist} object
}
\description{
Convert a set of rules in a dataframe to a \link{rulelist}
}
\details{
Input dataframe should contain these columns: \code{rule_nbr}, \code{LHS},
\code{RHS}. Providing other inputs helps augment better.
}
\examples{
rules_df = tidytable::tidytable(rule_nbr = 1:2,
                                LHS      = c("var_1 > 50", "var_2 < 30"),
                                RHS      = c(2, 1)
                                )
as_rulelist(rules_df, estimation_type = "regression")
}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}
}
