% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.cubist}
\alias{tidy.cubist}
\title{Get the \link{rulelist} from a \link[Cubist:cubist.default]{cubist} model}
\usage{
\method{tidy}{cubist}(x, ...)
}
\arguments{
\item{x}{\link[Cubist:cubist.default]{Cubist::cubist} model}

\item{...}{Other arguments (currently unused)}
}
\value{
A \link{rulelist} object
}
\description{
Each row corresponds to a rule per \code{committee}
}
\details{
\itemize{
\item The output columns are: \code{rule_nbr}, \code{committee}, \code{LHS}, \code{RHS}, \code{support}, \code{mean}, \code{min}, \code{max}, \code{error}.
\item Rules are sorted in this order per committee:
\code{error}, \code{desc(support)}
}
}
\examples{
att = modeldata::attrition
cols_att    = setdiff(colnames(att), c("MonthlyIncome", "Attrition"))
model_cubist = Cubist::cubist(x = att[, cols_att],
                              y = att[["MonthlyIncome"]]
                              )
tidy(model_cubist)

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}

Other Core Tidy Utility: 
\code{\link{tidy}()},
\code{\link{tidy.C5.0}()},
\code{\link{tidy.rpart}()}
}
\concept{Core Tidy Utility}
